capture log close
clear all
macro drop _all
cd "/Volumes/Mike2025/MC_CLIENTS/2025/AER 2025/Stata/Time Varying Models-smpl2020"
set more off
set maxiter 10000

**** SET PERIOD ***
local perd "long"      // can be "long" or "short"

log using "Output/log/LSE-AJTT-GTC/anOpexReg24-LSE-AJTT-GTC-`perd'", ///
	replace text

/*--------------------------------------------------------------------------
Project: Quantonomics DNSP Opex Cost Function - Time-Varying Models
			LSE Models
Author:  Alice Giovani & Michael Cunningham
File:    anOpexReg24-TimeVarying-LSE-AJTT-GTC.do
Initial Date:    29-Mar-2025
Revised Date:	 1-Aug-2025

--------------------------------------------------------------------------*/

* Period & dependent variable
if "`perd'" == "long" {
	local startyr 2006
	}
else if "`perd'" == "short" {
	local startyr 2012
}
local endyr   2020

* 
scalar define ppp_aust   		   = 1.527404363
scalar define ppp_nz    		   = 1.482877481
scalar define ppp_canada		   = 1.249076963

scalar define propex_rebase_aust   = 1.238501756
scalar define propex_rebase_nz     = 1.219668445
scalar define propex_rebase_canada = 1.160126855  

* Read data
use "Input/DNSPopex24", clear
xtset eiid year

gen int dnsp = eiid - 1000 if country == 1
qui tabulate dnsp, gen(d)
forvalues k = 1/13 {
	replace d`k' = 0 if d`k' == .
}

tabulate country, gen(jur)
correlate custnum circlen rmdem shareugc
tabulate year

summarize d* jur*

* Sample selection
*-------------------------
drop if country == 3 & year < (`startyr' - 1)
drop if country < 3 & year < `startyr'
drop if country == 3 & year > (`endyr' - 1)
drop if country < 3 & year > `endyr'

* Modify & create variables
*--------------------------

* Adressing change of VIC's DNSP from calendar to financial year in 2021
generate yr=year
replace yr=yr+0.5 if dnsp==3 & year<2021
replace yr=yr+0.5 if dnsp==8 & year<2021
replace yr=yr+0.5 if dnsp==9 & year<2021
replace yr=yr+0.5 if dnsp==11 & year<2021
replace yr=yr+0.5 if dnsp==13 & year<2021
replace yr=yr-0.25 if country==2
replace yr=yr+0.5 if country==3

replace propex = propex / propex_rebase_aust    if country==1
replace propex = propex / propex_rebase_nz      if country==2
replace propex = propex / propex_rebase_canada  if country==3
replace propex = propex * ppp_nz / ppp_aust     if country==2
replace propex = propex * ppp_canada / ppp_aust if country==3

* Regression log variables
gen lvc = log(opex / propex)
gen ly1 = log(custnum)
gen ly2 = log(circlen)
gen ly3 = log(rmdem)
gen lz1 = log(shareugc)

* mean correct output data
qui reg ly1
predict mly1
replace ly1=ly1-mly1
qui reg ly2
predict mly2
replace ly2=ly2-mly2
qui reg ly3
predict mly3
replace ly3=ly3-mly3

* TLG variables
gen ly11 = (ly1^2)/2
gen ly12 = ly1*ly2
gen ly13 = ly1*ly3
gen ly22 = (ly2^2)/2
gen ly23 = ly2*ly3
gen ly33 = (ly3^2)/2

center yr, generate(t)

*Time Trend Variables
gen t_aus = cond(country == 1,t,0)
gen t_nz  = cond(country == 2,t,0)
gen t_ont = cond(country == 3,t,0)
forvalues i = 1/13 {
    gen dt`i' = d`i'* t
}

*General technical change index dummies
gen yearx = 0
replace yearx = year - 2004 if country == 3
replace yearx = year - 2005 if country < 3
 
qui tabulate yearx, generate(yr)
 
gen gtc1 = cond(yearx >= 1 & yearx <= 3,1,0)
gen gtc2 = cond(yearx >= 4 & yearx <= 6,1,0)
gen gtc3 = cond(yearx >= 7 & yearx <= 9,1,0)
gen gtc4 = cond(yearx >= 10 & yearx <= 12,1,0)
gen gtc5 = cond(yearx >= 13 & yearx <= 15,1,0)
gen gtc6 = cond(yearx >= 16 & yearx <= 18,1,0)
 
if "`perd'" == "long" {
                local gtcvars gtc2-gtc5
				local cdnum = 38
				local tlgnum = 44
                }
else if "`perd'" == "short" {
                local gtcvars gtc4-gtc5
				local cdnum = 36
				local tlgnum = 42
}

* Labels
label variable ly1  "ln(Custnum)=x1" 
label variable ly2  "ln(CircLen)=x2" 
label variable ly3  "ln(RMDemand)=x3" 
label variable lz1  "ln(ShareUGC)" 
label variable ly11 "x1*x1/2" 
label variable ly12 "x1*x2" 
label variable ly13 "x1*x3" 
label variable ly22 "x2*x2/2" 
label variable ly23 "x2*x3" 
label variable ly33 "x3*x3/2"
label variable yr   "Year" 
label variable jur2 "New Zealand" 
label variable jur3 "Ontario" 

* Documentation

putdocx begin
putdocx paragraph, style(Title)
putdocx text ("LSE-AJTT-GTC - `perd' period" )

* Regression models
*---------------------- 
*================================
* 1. LSECD
*================================

xtpcse lvc ly1 ly2 ly3 lz1 `gtcvars' jur2 jur3 d2-d13 dt1-dt13 t_nz , ///
	c(a) het  
estimates store LSECD

* STATS TESTS
predict yhat, xb
gen eh = lvc - yhat

qui corr lvc yhat
local psadjr2 = 1 - ((1 - r(rho)^2)*(r(N) - 1)/(r(N) - `cdnum'))	
display "LSECD Pseudo-adjusted R2 = " `psadjr2'

iqr eh
swilk eh
collin ly1 ly2 ly3 lz1 `gtcvars' jur2 jur3 d2-d13 dt1-dt13 t_nz

* OUTPUT ELASTICITIES	
predictnl ely1 = (_b[ly1]), ci(lw_y1 up_y1)
predictnl ely2 = (_b[ly2]), ci(lw_y2 up_y2)
predictnl ely3 = (_b[ly3]), ci(lw_y3 up_y3)
predictnl elY  = (_b[ly1] + _b[ly2] + _b[ly3]), ci(lw_Y up_Y)

label var ely1 "ely1"
label var ely2 "ely2"
label var ely3 "ely3"
label var elY  "elY"
label var lw_y1 "lw_y1"
label var up_y1 "up_y1"
label var lw_y2  "lw_y2"
label var up_y2  "up_y2"
label var lw_y3  "lw_y3"
label var up_y3  "up_y3"
label var lw_Y  "lw_Y"
label var up_Y  "up_Y"

putdocx paragraph, style(Subtitle)
putdocx text ("LSECD-AJTT-GTC Elasticities - `perd' period")
table (country) (var) , stat(mean ely1 ely2 ely3 elY) nformat(%5.3f)
putdocx collect

* Efficiency scores

predictnl eff1 =exp(-(_b[dt1]*t ///
	- min(_b[dt1]*t, _b[d2]+ _b[dt2]*t, _b[d3]+ _b[dt3]*t, ///
	_b[d4]+ _b[dt4]*t, _b[d5]+ _b[dt5]*t, _b[d6]+ _b[dt6]*t, ///
	_b[d7]+ _b[dt7]*t, _b[d8]+ _b[dt8]*t, _b[d9]+ _b[dt9]*t, ///
	_b[d10]+ _b[dt10]*t, _b[d11]+ _b[dt11]*t, _b[d12]+ _b[dt12]*t, ///
	_b[d13]+ _b[dt13]*t))), ci(eff1_lb eff1_ub)
gen eff    = eff1    if dnsp == 1
gen eff_lb = eff1_lb if dnsp == 1
gen eff_ub = eff1_ub if dnsp == 1	

forvalues j = 2/13 {
	predictnl eff`j' = exp(-(_b[d`j'] + _b[dt`j']*t ///
		- min(_b[dt1]*t, _b[d2]+ _b[dt2]*t, _b[d3]+ _b[dt3]*t, ///
		_b[d4]+ _b[dt4]*t, _b[d5]+ _b[dt5]*t, _b[d6]+ _b[dt6]*t, ///
		_b[d7]+ _b[dt7]*t, _b[d8]+ _b[dt8]*t, _b[d9]+ _b[dt9]*t, ///
		_b[d10]+ _b[dt10]*t, _b[d11]+ _b[dt11]*t, ///
		_b[d12]+ _b[dt12]*t, _b[d13]+ _b[dt13]*t))), ///
		ci(eff`j'_lb  eff`j'_ub)
  replace eff    = eff`j'    if dnsp == `j'
  replace eff_lb = eff`j'_lb if dnsp == `j'
  replace eff_ub = eff`j'_ub if dnsp == `j'		
}
	
drop eff1  eff1_lb  eff1_ub  eff2  eff2_lb  eff2_ub  eff3  eff3_lb  eff3_ub ///
	eff4  eff4_lb  eff4_ub  eff5  eff5_lb  eff5_ub  eff6  eff6_lb  eff6_ub ///
	eff7  eff7_lb  eff7_ub  eff8  eff8_lb  eff8_ub  eff9  eff9_lb  eff9_ub ///
	eff10 eff10_lb eff10_ub eff11 eff11_lb eff11_ub eff12 eff12_lb eff12_ub ///
	eff13 eff13_lb eff13_ub 	
	
*Charts	
twoway (line eff year if dnsp == 1,  sort lcolor(blue)      lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 2,  sort lcolor(red)       lpattern(dash)        lwidth(0.5)) ///
       (line eff year if dnsp == 3,  sort lcolor(green)     lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 4,  sort lcolor(orange)    lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 5,  sort lcolor(maroon)    lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 6,  sort lcolor(teal)      lpattern(dash)        lwidth(0.5)) ///
       (line eff year if dnsp == 7,  sort lcolor(magenta)   lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 8,  sort lcolor(dkgreen)   lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 9,  sort lcolor(purple)    lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 10, sort lcolor(brown)     lpattern(dash)        lwidth(0.5)) ///
       (line eff year if dnsp == 11, sort lcolor(navy)      lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 12, sort lcolor(pink)      lpattern(solid) 	  lwidth(0.5)) ///
       (line eff year if dnsp == 13, sort lcolor(olive)     lpattern(solid)       lwidth(0.5)), ///
       legend(order(1 "EVO" 2 "AGD" 3 "CIT" 4 "END" 5 "ENX" ///
                    6 "ERG" 7 "ESS" 8 "JEN" 9 "PCR" 10 "SAP" ///
                    11 "AND" 12 "TND" 13 "UED") title("DNSP")) ///
       xtitle("Year") ytitle("Efficiency Score") ///
       xlabel(`startyr'(1)`endyr', angle(90) grid)  /// 
       ylabel(0(0.1)1, grid) /// 
       xscale(range(`startyr' `endyr')) /// 
       yscale(range(0 1))       

graph export "Output/chart/LSE-AJTT-GTC/LSECD-AJTT-GTC-Eff-`perd'.png", replace
putdocx paragraph, halign(center)
putdocx image "Output/chart/LSE-AJTT-GTC/LSECD-AJTT-GTC-Eff-`perd'.png", ///
	width(8) height(5.6)

putdocx pagebreak
putdocx paragraph, style(Subtitle)
putdocx text ("LSECD-AJTT-GTC Efficiencies - `perd' period")
table (dnsp) (var) , stat(mean eff eff_lb eff_ub) nformat(%5.3f)
putdocx collect

export excel eiid year eff eff_lb eff_ub using        ///
	"Output/xlsx/LSE-AJTT-GTC/LSE-AJTT-GTC-Eff-`perd'.xlsx" ///
	if dnsp < 14,  firstrow(var) sheet("LSECD") replace nolabel

* Residuals plots

scatter eh yhat if country == 1, mcolor(blue) ///
    || scatter eh yhat if country == 2, mcolor(red) ///
    || scatter eh yhat if country == 3, mcolor(green) ///
    yline(0) ///
    ytitle("Residuals") ///
    xtitle("Fitted Values") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))
graph export "Output/chart/LSE-AJTT-GTC/LSECD-AJTT-GTC-Res-`perd'.png", ///
	replace
putdocx paragraph, halign(center)
putdocx image "Output/chart/LSE-AJTT-GTC/LSECD-AJTT-GTC-Res-`perd'.png", ///
	width(8) height(5.6)
	
	
estout  LSECD using "Output/xlsx/LSE-AJTT-GTC/LSECD-AJTT-GTC-Reg-`perd'.tsv", ///
	cells("b(fmt(4)) se(fmt(4)) t(fmt(4))") style(tab) label ///
	title("LSECD-AJTT-GTC-`perd' period") stats(N bic, fmt(3)) replace

drop ely1 lw_y1 up_y1 ely2 lw_y2 up_y2 ely3 lw_y3 up_y3 elY lw_Y up_Y yhat ///
	eh eff  eff_lb eff_ub


*================================
* 2. LSETLG
*================================
xtpcse lvc ly1 ly2 ly3 ly11 ly12 ly13 ly22 ly23 ly33 lz1 `gtcvars' jur2 jur3 ///
	d2-d13 dt1-dt13 t_nz , c(a) het

estimates store LSETLG

* STATS TESTS
predict yhat, xb
gen eh = lvc - yhat

qui corr lvc yhat
local psadjr2 = 1 - ((1 - r(rho)^2)*(r(N) - 1)/(r(N) - `tlgnum'))	
display "LSETLG Pseudo-adjusted R2 = " `psadjr2'

iqr eh
swilk eh
collin ly1 ly2 ly3 ly11 ly12 ly13 ly22 ly23 ly33 lz1 `gtcvars' jur2 jur3 ///
	   d2-d13 dt1-dt13 t_nz

test ly11 ly12 ly13 ly22 ly23 ly33

* OUTPUT ELASTICITIES	

predictnl ely1 = (_b[ly1] + _b[ly11]*ly1 + _b[ly12]*ly2 + _b[ly13]*ly3), ///
	ci(lw_y1 up_y1) 
predictnl ely2 = (_b[ly2] + _b[ly12]*ly1 + _b[ly22]*ly2 + _b[ly23]*ly3), ///
	ci(lw_y2 up_y2)
predictnl ely3 = (_b[ly3] + _b[ly13]*ly1 + _b[ly23]*ly2 + _b[ly33]*ly3), ///
	ci(lw_y3 up_y3) 
predictnl elY  = (_b[ly1]  + _b[ly11]*ly1 + _b[ly12]*ly2 + _b[ly13]*ly3 + ///
	_b[ly2] + _b[ly12]*ly1 + _b[ly22]*ly2 + _b[ly23]*ly3 + _b[ly3] + ///
	_b[ly13]*ly1 + _b[ly23]*ly2 + _b[ly33]*ly3), ci(lw_Y up_Y)

label var ely1 "ely1"
label var ely2 "ely2"
label var ely3 "ely3"
label var elY  "elY"
label var lw_y1 "lw_y1"
label var up_y1 "up_y1"
label var lw_y2  "lw_y2"
label var up_y2  "up_y2"
label var lw_y3  "lw_y3"
label var up_y3  "up_y3"
label var lw_Y  "lw_Y"
label var up_Y  "up_Y"

putdocx pagebreak
putdocx paragraph, style(Subtitle)
putdocx text ("LSETLG-AJTT-GTC Elasticities - `perd' period")
table (country) (var) , stat(mean ely1 ely2 ely3 elY) nformat(%5.3f)
putdocx collect
table (dnsp) (var) , stat(mean ely1 ely2 ely3 elY) nformat(%5.3f)
putdocx collect

display "MONOTONICITY VIOLATIONS"
gen mon1 = 0
gen mon2 = 0
gen mon3 = 0
gen montot = 0
replace mon1 = cond(ely1 < 0,100,0)	
replace mon2 = cond(ely2 < 0,100,0)	
replace mon3 = cond(ely3 < 0,100,0)
replace montot = 100 if mon1 == 100 | mon2 == 100 | mon3 == 100

putdocx pagebreak
putdocx paragraph, style(Subtitle)
putdocx text ("LSETLG-AJTT-GTC Monotonicity Violations - `perd' period")
table (country) (var) , stat(mean mon1 mon2 mon3 montot) nformat(%5.1f)
putdocx collect
table (dnsp) (var) , stat(mean mon1 mon2 mon3 montot) nformat(%5.1f)
putdocx collect

export excel eiid year country custnum rmdem circlen ely1 ely2 ely3 ///
	using Output/xlsx/LSE-AJTT-GTC/monotonicity-`perd'.xlsx, ///
	sheet("LSETLG", replace) firstrow(var) 	


** Efficiency scores

predictnl eff1 = exp(-( _b[dt1]*t ///
	- min(_b[dt1]*t, _b[d2]+ _b[dt2]*t, _b[d3]+ _b[dt3]*t, ///
	_b[d4]+ _b[dt4]*t, _b[d5]+ _b[dt5]*t, _b[d6]+ _b[dt6]*t, ///
	_b[d7]+ _b[dt7]*t, _b[d8]+ _b[dt8]*t, _b[d9]+ _b[dt9]*t, ///
	_b[d10]+ _b[dt10]*t, _b[d11]+ _b[dt11]*t, _b[d12]+ _b[dt12]*t, ///
	_b[d13]+ _b[dt13]*t))), ci(eff1_lb eff1_ub)
gen eff    = eff1    if dnsp == 1
gen eff_lb = eff1_lb if dnsp == 1
gen eff_ub = eff1_ub if dnsp == 1	

forvalues j = 2/13 {
	predictnl eff`j' = exp(-(_b[d`j'] + _b[dt`j']*t ///
		- min(_b[dt1]*t, _b[d2]+ _b[dt2]*t, _b[d3]+ _b[dt3]*t, ///
		_b[d4]+ _b[dt4]*t, _b[d5]+ _b[dt5]*t, _b[d6]+ _b[dt6]*t, ///
		_b[d7]+ _b[dt7]*t, _b[d8]+ _b[dt8]*t, _b[d9]+ _b[dt9]*t, ///
		_b[d10]+ _b[dt10]*t, _b[d11]+ _b[dt11]*t, ///
		_b[d12]+ _b[dt12]*t, _b[d13]+ _b[dt13]*t))), ///
		ci(eff`j'_lb  eff`j'_ub)
  replace eff    = eff`j'    if dnsp == `j'
  replace eff_lb = eff`j'_lb if dnsp == `j'
  replace eff_ub = eff`j'_ub if dnsp == `j'		
}
	
drop eff1  eff1_lb  eff1_ub  eff2  eff2_lb  eff2_ub  eff3  eff3_lb  eff3_ub ///
	eff4  eff4_lb  eff4_ub  eff5  eff5_lb  eff5_ub  eff6  eff6_lb  eff6_ub ///
	eff7  eff7_lb  eff7_ub  eff8  eff8_lb  eff8_ub  eff9  eff9_lb  eff9_ub ///
	eff10 eff10_lb eff10_ub eff11 eff11_lb eff11_ub eff12 eff12_lb eff12_ub ///
	eff13 eff13_lb eff13_ub 	
	
*Charts	
twoway (line eff year if dnsp == 1,  sort lcolor(blue)      lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 2,  sort lcolor(red)       lpattern(dash)        lwidth(0.5)) ///
       (line eff year if dnsp == 3,  sort lcolor(green)     lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 4,  sort lcolor(orange)    lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 5,  sort lcolor(maroon)    lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 6,  sort lcolor(teal)      lpattern(dash)        lwidth(0.5)) ///
       (line eff year if dnsp == 7,  sort lcolor(magenta)   lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 8,  sort lcolor(dkgreen)   lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 9,  sort lcolor(purple)    lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 10, sort lcolor(brown)     lpattern(dash)        lwidth(0.5)) ///
       (line eff year if dnsp == 11, sort lcolor(navy)      lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 12, sort lcolor(pink)      lpattern(solid) 	  lwidth(0.5)) ///
       (line eff year if dnsp == 13, sort lcolor(olive)     lpattern(solid)       lwidth(0.5)), ///
       legend(order(1 "EVO" 2 "AGD" 3 "CIT" 4 "END" 5 "ENX" ///
                    6 "ERG" 7 "ESS" 8 "JEN" 9 "PCR" 10 "SAP" ///
                    11 "AND" 12 "TND" 13 "UED") title("DNSP")) ///
       xtitle("Year") ytitle("Efficiency Score") ///
       xlabel(`startyr'(1)`endyr', angle(90) grid)  /// 
       ylabel(0(0.1)1, grid) /// 
       xscale(range(`startyr' `endyr')) /// 
       yscale(range(0 1))       

graph export "Output/chart/LSE-AJTT-GTC/LSETLG-AJTT-GTC-Eff-`perd'.png", replace
putdocx paragraph, halign(center)
putdocx image "Output/chart/LSE-AJTT-GTC/LSETLG-AJTT-GTC-Eff-`perd'.png", ///
	width(8) height(5.6)

putdocx pagebreak	
putdocx paragraph, style(Subtitle)
putdocx text ("LSETLG-AJTT-GTC Efficiencies")
table (dnsp) (var) , stat(mean eff eff_lb eff_ub) nformat(%5.3f)
putdocx collect

export excel eiid year eff eff_lb eff_ub using        ///
	"Output/xlsx/LSE-AJTT-GTC/LSE-AJTT-GTC-Eff-`perd'.xlsx" ///
	if dnsp < 14,  firstrow(var) sheet("LSETLG", modify) nolabel

* Residuals plots

scatter eh yhat if country == 1, mcolor(blue) ///
    || scatter eh yhat if country == 2, mcolor(red) ///
    || scatter eh yhat if country == 3, mcolor(green) ///
    yline(0) ///
    ytitle("Residuals") ///
    xtitle("Fitted Values") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))
graph export "Output/chart/LSE-AJTT-GTC/LSETLG-AJTT-GTC-Res-`perd'.png", ///
	replace
putdocx paragraph, halign(center)
putdocx image "Output/chart/LSE-AJTT-GTC/LSETLG-AJTT-GTC-Res-`perd'.png", ///
	width(8) height(5.6)


estout  LSETLG using "Output/xlsx/LSE-AJTT-GTC/LSETLG-AJTT-GTC-Reg-`perd'.tsv", ///
	cells("b(fmt(4)) se(fmt(4)) t(fmt(4))") /// 
	style(tab) label title("LSETLG-AJTT-GTC-`perd' period") stats(N bic, fmt(3)) replace

putdocx save "Output/docx/LSE-AJTT-GTC/LSETLG-AJTT-GTC-`perd'", replace


log close

